

local _l_track = ac.getTrackID()

local _l_config_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\Pure LCS"
local _l_config_file = _l_config_path.."\\pure_config.ini"
local _l_ppfilter_related_config_file = nil
local _l_ppfilter_related_config_file__loaded = nil
local _l_config_track_file = _l_config_path.."\\pure_config_".._l_track..".ini"
local _l_config_track_file_short = "pure_config_".._l_track..".ini"
local _l_config_track_file_used = false
check_folder_and_create(ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\Pure LCS\\")
local _l_config_file_mode = "default"
local _l_config_file_add = ""

local _l_PureConfigSelectedTab = ""

function __PURE__get_config_additional_name()
    return _l_config_file_add
end



local _l_config_data = {

    AI_headlights = {

        sun             = { id=101, value=7.0, min=-3.0, max=12.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        ambient_light   = { id=102, value=9.0, min=0.0, max=20.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        CBE             = { id=103, value=0.60, min=0.0, max=5.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        fog             = { id=104, value=0.40, min=0.0, max=1.00, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain            = { id=105, value=0.07, min=0.0, max=1.00, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        headlights_ctrl = { id=106, value=0, min=0, max=1000, type=TYPES.INTEGER, relative=RELATIVE_MODE.NONE },
        high_beams_ctrl = { id=107, value=0, min=0, max=1000, type=TYPES.INTEGER, relative=RELATIVE_MODE.NONE },
    },

    light = {

        daylight_multiplier = { id=901, value=1.0, min=0.1, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        sun = {
            hue         = { id=1001, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1002, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1003, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            speculars   = { id=1004, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        ambient_model_V2  = { id=1009, value=true, reset=false, type=TYPES.BOOLEAN },

        ambient = {
            hue         = { id=1011, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1012, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1013, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            minimum     = { id=1014, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        ambient_radiosity = {
            hue         = { id=1021, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1022, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1023, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            vao_exp     = { id=1024, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            mix         = { id=1025, value=1.0, min=0.0, max=1.0,  type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        distant_ambient = {
            hue         = { id=1023, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1024, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1025, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            distance    = { id=1026, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        directional_ambient = {
            hue         = { id=1027, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1028, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1029, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            distance    = { id=1030, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        sky = {
            hue         = { id=1031, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
            saturation  = { id=1032, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            level       = { id=1033, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },

        grass_shading   = {
            specularity     = { id=1203, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            reflectivity    = { id=1204, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            backlit         = { id=1205, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            saturation      = { id=1206, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },
    },

    fog = {
        far = {
            distance        = { id=1101, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            blend           = { id=1102, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            exponent        = { id=1103, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            color = {
                hue         = { id=1104, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
                saturation  = { id=1105, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
                level       = { id=1106, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            },
        },
        near = {
            distance        = { id=1107, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            blend           = { id=1108, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            exponent        = { id=1109, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            height          = { id=1110, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            color = {
                hue         = { id=1111, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
                saturation  = { id=1112, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
                level       = { id=1113, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
            },
        },
        atmosphere      = { id=1114, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        sky             = { id=1115, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        backlit_level   = { id=1116, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        backlit_exponent= { id=1117, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        cubemaps        = { id=1117, value=1.0, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    World = {
        brightness      = { id=1201, value=1.0, min=0.0, max=4.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },
    Scene = {
        brightness      = { id=1202, value=1.0, min=0.0, max=4.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        CBE_usage       = { id=1203, value=1.00, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        tunnel_sunlight_dimmer  = { id=1211, value=true, reset=false, type=TYPES.BOOLEAN },
        tunnel_ambilight_dimmer = { id=1212, value=true, reset=false, type=TYPES.BOOLEAN },
        tunnel_fog_dimmer       = { id=1212, value=true, reset=false, type=TYPES.BOOLEAN },
        emissive_adaption       = { id=1213, value=true, reset=false, type=TYPES.BOOLEAN },
    },

    weather = {
        use_weather_particles = { id=2550, value=true, reset=false, type=TYPES.BOOLEAN },
        snow ={
            size = { id=1251, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },    
        ash ={
            size = { id=1261, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        },
        add_online_properties = { id=2560, value=true, reset=true, type=TYPES.BOOLEAN },
    },

    csp_lights = {
        bounce          = { id=1301, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        emissive        = { id=1302, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        true_emissive   = { id=1303, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        displays        = { id=1304, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        range           = { id=1305, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    reflections = {

        saturation      = { id=1401, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        level           = { id=1402, value=1.0, min=0.01, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        --emissive_boost  = { id=1403, value=6.0, min=0.0, max=30.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    vao = {
        amount           = { id=1501, value=1.000, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        track_exponent   = { id=1502, value=0.500, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        dynamic_exponent = { id=1503, value=0.500, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    ui = {
        white_reference_point = { id=1601, value=1.000, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    nlp ={
        level           = { id=1701, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        density         = { id=1702, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        lowest_ambient  = { id=1703, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    sun = {
        sun_moon_size   = { id=1800, value=1.5, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    moon = {
        no_shadows      = { id=1801, value=true, reset=false, type=TYPES.BOOLEAN },
        light           = { id=1802, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        appearance      = { id=1803, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    stars = {
        appearance       = { id=1901, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        dynamic_adaption = { id=1902, value=true, reset=false, type=TYPES.BOOLEAN },
    },

    camera = {
        occlusion_control = {
            adv_ambi_light      = { id=2001, value=false, reset=false, type=TYPES.BOOLEAN },
            adv_fog_ambi_light  = { id=2002, value=true, reset=false, type=TYPES.BOOLEAN },
            exposure            = { id=2003, value=true, reset=false, type=TYPES.BOOLEAN },
            overcast            = { id=2004, value=true, reset=false, type=TYPES.BOOLEAN },
            vao                 = { id=2005, value=true, reset=false, type=TYPES.BOOLEAN },
        },
    },

    sky = {
        saturation  = { id=2010, value=0.25, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        level       = { id=2011, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    clouds_render = {
        method              = { id=2020, value=1, min=0, max=1, reset=true, type=TYPES.INTEGER },
        shadows_strength    = { id=2106, value=1.0, min=-1.0, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        shadows_blur        = { id=2107, value=0.0, min=0.0, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },
--[[
    clouds = {

        distance = { id=2001, value=1.00, min=0.5, max=3.0, reset=true, type=TYPES.FLOAT },

        -- [0.0..1.0] override possible
        quality = { id=2002, value=0.85, min=0.0, max=4.0, reset=true, type=TYPES.FLOAT },

        advanced_lighting = { id=2003, value=true, reset=true, type=TYPES.BOOLEAN },

        -- 0 = calculate all clouds per frame
        -- 1 = eco position calculation of clouds beyond the limit
        -- 2 = no position calculation of clouds beyond the limit
        position_calculation_mode    = { id=2004, value=1, min=0, max=2, reset=true, type=TYPES.INTEGER },

        -- limit the position calculations of N clouds per frame
        -- set to -1 for no limit
        position_calculation_limiter = { id=2005, value=500, min=-1, max=500, reset=true, type=TYPES.INTEGER },

        -- limit the color calculations of N clouds per frame
        -- set to -1 for no limit
        color_calculation_limiter    = { id=2006, value=100, min=-1, max=500, reset=true, type=TYPES.INTEGER }, 
    },
]]

    clouds2D = {

        set = { id=2100, value="default_16k", min="", max="", reset=true, type=TYPES.STRING_STORE },
        quality = { id=2101, value=3, min=1, max=4, reset=true, type=TYPES.INTEGER },
        crossfade_time = { id=2102, value=20, min=1.0, max=180.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        wind_oscillation = { id=2103, value=1, min=0.0, max=2.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        advanced_shadows = { id=2104, value=true, reset=true, type=TYPES.BOOLEAN },
        advanced_shadows_sun_cover = { id=2105, value=false, reset=true, type=TYPES.BOOLEAN },
        advanced_shadows_speed = { id=2106, value=1.0, min=0.1, max=10, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        preload = { id=2108, value=false, reset=true, type=TYPES.BOOLEAN },
        unload = { id=2109, value=true, reset=true, type=TYPES.BOOLEAN },
        
        brightness = { id=2120, value=1, min=0.0, max=10.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        contrast = { id=2130, value=1, min=0.0, max=10.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        delayed_loading = { id=2140, value=0, min=0, max=10, reset=true, type=TYPES.INTEGER, relative=RELATIVE_MODE.NONE },
    },

    clouds_raymarching = {

        resolution = { id=2201, value=0.5, min=0.1, max=2.0, reset=true, type=TYPES.FLOAT },

        clouds = { id=2210, value=true, reset=false, type=TYPES.BOOLEAN },
        shadows = { id=2211, value=true, reset=false, type=TYPES.BOOLEAN },

        scale = { id=2220, value=1.0, min=0.1, max=10.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        softness = { id=2221, value=0.4, min=0.01, max=1.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        perf_reprojection = { id=2250, value=false, reset=false, type=TYPES.BOOLEAN },
        perf_fast = { id=2251, value=true, reset=false, type=TYPES.BOOLEAN },
        perf_detail = { id=2252, value=true, reset=false, type=TYPES.BOOLEAN },
        perf_variSteps = { id=2253, value=true, reset=false, type=TYPES.BOOLEAN },
        perf_maxDense = { id=2254, value=1.0, min=0.0, max=10.0, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        perf_samplesSky = { id=2255, value=2, min=0.125, max=4, reset=false, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        perf_samplesSkyAdaptive = { id=2256, value=false, reset=false, type=TYPES.BOOLEAN },
        perf_samplesLight = { id=2257, value=6, min=1, max=16, reset=false, type=TYPES.INTEGER },
        perf_extendedLightray = { id=2258, value=true, reset=false, type=TYPES.BOOLEAN },
        perf_extendedLightraySamples = { id=2259, value=3, min=1, max=8, reset=false, type=TYPES.INTEGER },

        blur = { id=2270, value=true, reset=false, type=TYPES.BOOLEAN },
        blur_width = { id=2271, value=2, min=1, max=3, reset=false, type=TYPES.INTEGER },

        upscale = { id=2280, value=true, reset=false, type=TYPES.BOOLEAN },

        debug_reprojection = { id=2290, value=false, reset=false, type=TYPES.BOOLEAN },
        debug_weather_position = { id=2290, value=false, reset=false, type=TYPES.BOOLEAN },
    },

    ppoff = {

        brightness = { id=3001, value=1.00, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },


    picture_adjust = {
        saturation  = { id=3012, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT },
        brightness  = { id=3013, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT },
        contrast    = { id=3014, value=1.0, min=0.0, max=2.0,  type=TYPES.FLOAT },
        color_temperature = { id=3015, value=6500, min=3000, max=10000, type=TYPES.INTEGER },
        gamma       = { id=3016, value=2.2, min=0.001, max=4.0, type=TYPES.FLOAT },
    },

--[[
    pp = {
        hue         = { id=4011, value=0.0, min=-180, max=180, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        saturation  = { id=4012, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        luma_saturation  = { id=4013, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        luma_threshold   = { id=4014, value=1.0, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        brightness  = { id=4015, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        contrast    = { id=4016, value=1.0, min=0.0, max=2.0,  type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        color_temperature = { id=4017, value=6500, min=3000, max=10000, type=TYPES.INTEGER, relative=RELATIVE_MODE.MULTIPLIER },
        gamma       = { id=4018, value=1.0, min=0.001, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        godrays     = { id=4019, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    ppTonemapUtils = {
        debug_clipping = { id=3101, value=false, reset=false, type=TYPES.BOOLEAN },
        debug_curve    = { id=3102, value=false, reset=false, type=TYPES.BOOLEAN },
        debug_curve_X    = { id=3103, value=0.84, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.NONE },
        debug_curve_Y    = { id=3104, value=0.05, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.NONE },
        debug_curve_SIZE = { id=3105, value=0.15, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.NONE },
    },

    ppTonemapUchimura = {
        maxDisplayBrightness    = { id=3201, value=2.0, min=0.0, max=5.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        contrast                = { id=3202, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        linearSectionStart      = { id=3203, value=0.3, min=0.001, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        linearSectionLength     = { id=3204, value=0.4, min=0.0, max=0.98, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        black                   = { id=3205, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        pedestal                = { id=3206, value=0.0, min=-0.1, max=0.1, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        gain                    = { id=3207, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
    },

    ppTonemapLottes = {
        contrast    = { id=3301, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        gamma       = { id=3302, value=1.0, min=0.0, max=2.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        hdrMax      = { id=3303, value=1.0, min=0.0, max=5.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        midIn       = { id=3304, value=0.5, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        midOut      = { id=3305, value=0.5, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
        gain        = { id=3306, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.OFFSET },
    },
]]

    sound = {

        wind_volume_interior = { id=4001, value=0.25, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        wind_volume_exterior = { id=4002, value=1.00, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        wind_volume_speed_damping = { id=4003, value=0.75, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        rain_volume_interior = { id=4004, value=0.80, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain_volume_exterior = { id=4005, value=1.00, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain_volume_speed_damping = { id=4006, value=0.75, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        damping_at_speed = { id=4006, value=200, min=0.0, max=500.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        rain_volume_extra_skid = { id=4007, value=1.00, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain_volume_extra_wetness = { id=4008, value=1.00, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain_volume_extra_puddles = { id=4009, value=1.00, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        rain_volume_extra_gravel = { id=4010, value=1.00, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },

        thunder_volume_interior = { id=4011, value=1.00, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        thunder_volume_exterior = { id=4012, value=1.00, min=0.0, max=1.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    },

    debug = {

        memory      = { id=5001, value=false, reset=true, type=TYPES.BOOLEAN },
        computation = { id=5002, value=false, reset=true, type=TYPES.BOOLEAN },
        --fps         = { id=5002, value=false, reset=true, type=TYPES.BOOLEAN },
        --stellar     = { id=5003, value=false, reset=true, type=TYPES.BOOLEAN },
        --ai          = { id=5004, value=false, reset=true, type=TYPES.BOOLEAN },
        --weather     = { id=5005, value=false, reset=true, type=TYPES.BOOLEAN },
        --clouds      = { id=5006, value=false, reset=true, type=TYPES.BOOLEAN },
        --nlp         = { id=5007, value=false, reset=true, type=TYPES.BOOLEAN },
        graphics    = { id=5008, value=false, reset=true, type=TYPES.BOOLEAN },
        --camera      = { id=5009, value=false, reset=true, type=TYPES.BOOLEAN },
    },

    info = {
        test_slider  = { id=6001, value=1.00, min=-2.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        test_slider2 = { id=6002, value=1.00, min=-2.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        test_slider3 = { id=6003, value=1.00, min=-2.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    }
}

if ac.setReflectedSkyTweaks~=nil then
    _l_config_data.reflections.sky = {
        luminance = { id=1403, value=1.0, min=0.0, max=100.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        saturation = { id=1403, value=1.0, min=0.0, max=10.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
        gamma = { id=1403, value=1.0, min=0.0, max=3.0, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER },
    }
end

local _l_shader_config_start_general_id = 10000
local _l_shader_config_start_id = _l_shader_config_start_general_id

function __PURE__add_shader_config(shader)
    if _l_config_data["shaders"] == nil then
        _l_config_data["shaders"] = {}
    end
    if _l_config_data["shaders"][shader] == nil then
        _l_config_data["shaders"][shader] = {}
        _l_shader_config_start_id = _l_shader_config_start_id + 1000
        _l_shader_config_start_id = _l_shader_config_start_id + 1
        _l_config_data["shaders"][shader].active = { id=_l_shader_config_start_id, value=true, reset=false, type=TYPES.BOOLEAN }
    end
end

-- register the shaders at this point. So the are in the config with the "active" parameter, even there are no others
--__PURE___initialize_shaders()

function __PURE__add_shader_config_parameter(shader, s_name, s_value, s_min, s_max, s_type, s_relative, s_reset)
    --ac.debug(shader..s_name, s_value)
    if shader and shader~="" then
        if _l_config_data["shaders"] == nil or _l_config_data["shaders"][shader] == nil then
            __PURE__add_shader_config(shader)
        end
        
        if s_name and s_name~= "" then
            local relative = -1
            if s_relative == "multiplier" then relative = RELATIVE_MODE.MULTIPLIER
            elseif s_relative == "offset" then relative = RELATIVE_MODE.OFFSET end

            s_reset = s_reset or false

            _l_shader_config_start_id = _l_shader_config_start_id + 1
            if s_type == "float" then
                _l_config_data["shaders"][shader][s_name] = { id=_l_shader_config_start_id, value=s_value, min=s_min, max=s_max, reset=s_reset, type=TYPES.FLOAT, relative=RELATIVE_MODE.MULTIPLIER }
                if relative >= 0 then
                    _l_config_data["shaders"][shader][s_name].relative = relative
                end
            elseif s_type == "integer" then
                _l_config_data["shaders"][shader][s_name] = { id=_l_shader_config_start_id, value=s_value, min=s_min, max=s_max, reset=s_reset, type=TYPES.INTEGER, relative=RELATIVE_MODE.MULTIPLIER }
                if relative >= 0 then
                    _l_config_data["shaders"][shader][s_name].relative = relative
                end
            elseif s_type == "boolean" then
                _l_config_data["shaders"][shader][s_name] = { id=_l_shader_config_start_id, value=s_value, reset=s_reset, type=TYPES.BOOLEAN }
            elseif s_type == "string" then
                _l_config_data["shaders"][shader][s_name] = { id=_l_shader_config_start_id, value=s_value, reset=false, type=TYPES.STRING }
            elseif s_type == "system_state" then
                _l_config_data["shaders"][shader][s_name] = { id=_l_shader_config_start_id, value=s_value, reset=false, type=TYPES.SYSTEM_BOOLEAN }
            elseif s_type == "info" then
                local tmp = math.floor((_l_shader_config_start_id - _l_shader_config_start_general_id) * 0.001)*1000 + _l_shader_config_start_general_id
                _l_config_data["shaders"][shader][s_name] = { id=tmp, value=s_value, reset=false, type=TYPES.STRING }
            end
        else
            ac.debug("Pure Error", "Shader "..shader..", invalid parameter name!")
        end
    else
        ac.debug("Pure Error", "invalid shader name!")
    end
end

function __PURE__add_shader_config_SliderFloat(shader, s_name, s_value, s_min, s_max, s_relative)
    __PURE__add_shader_config_parameter(shader, s_name, s_value, s_min, s_max, "float", s_relative, false)
end

function __PURE__add_shader_config_SliderInteger(shader, s_name, s_value, s_min, s_max, s_relative)
    __PURE__add_shader_config_parameter(shader, s_name, s_value, s_min, s_max, "integer", s_relative, false)
end

function __PURE__add_shader_config_Checkbox(shader, s_name, s_value, s_reset)
    __PURE__add_shader_config_parameter(shader, s_name, s_value, nil, nil, "boolean", nil, s_reset)
end

function __PURE__add_shader_config_Text(shader, s_name, s_value)
    __PURE__add_shader_config_parameter(shader, s_name, s_value, nil, nil, "string", nil, false)
end

function __PURE__add_shader_info(shader, s_value)
    __PURE__add_shader_config_parameter(shader, "info", s_value, nil, nil, "info", nil, false)
end

function __PURE__add_shader_config_SystemState(shader, name, value)
    __PURE__add_shader_config_parameter(shader, name, value, nil, nil, "system_state", nil, false)
end

function __PURE__reset_Pure_when_changing_shaders_active_state(shader, b)
    if _l_config_data["shaders"][shader]~=nil and _l_config_data["shaders"][shader].active~=nil then
        _l_config_data["shaders"][shader].active.reset=b
    end
end




-- initialize all other shader parameters
if __ECO__ then
    PURE_shaders_set_ECO_Settings()
else
    __PURE__check_and_initialize_shader_settings()
end






local _l_Config = ConfigTable:new(_l_config_data, true, "PureConfig", __PURE_version)
_l_Config:initialize()


local _l_Config_Parser = ConfigParser:new()

local _l_config_init = false




function __PURE__set_config_access(key, v)
    -- ENTRY_ACCESS_MODE.ALLOW
    -- ENTRY_ACCESS_MODE.PREVENT
    return _l_Config:setEntryAccess(key, v)
end

function __PURE__set_config_MinMax(key, min, max)
    _l_Config:setMinMax(key, min, max, CONFIG_ACCESS_MODE.DIRECT)
end

function __PURE__set_config_default(key, value)
    _l_Config:setEntryDefault(key, value)
end

--- Get a Pure config parameter
---@param key string @The parameters key (The full name right next to the slider)
---@return number|boolean|string|nil @returns the set value or `nil` if the parameter doesn't exist.
function __PURE__get_config(key)
    local a, b = string.find(key, "pp")
    if a==1 then
        a, b = string.find(key, "ppTonemapUtils")
        if a==1 then
            return __PURE__get_root_config(key)
        else
            return __PURE__get_PP_config(key)
        end
    else
        return _l_Config:getEntry(key)
    end
end

function __PURE__set_config_DIRECT(key, value, bRelative)
    return _l_Config:setEntry(key, value, bRelative, CONFIG_ACCESS_MODE.DIRECT)
end

--- Set a Pure config parameter
---@param key string @The parameters key (The full name right next to the slider)
---@param value number|boolean|string @The parameters value
---@param bRelative boolean @If set to true, the parameter is change relativaly. The user will still be able to adjust it. Default: false
---@return number|boolean|string|nil @returns the set value or `nil` if the parameter doesn't exist.
function __PURE__set_config(key, value, bRelative)
    local a, b = string.find(key, "pp")
    if a==1 then
        a, b = string.find(key, "ppTonemapUtils")
        if a==1 then
            return __PURE__set_root_config(key, value)
            --_l_ConfigRoot:writeFileAfterUpdate(_l_rootconfig_file)
        else
            return __PURE__set_PP_config(key, value, bRelative)
        end
    else
        return _l_Config:setEntry(key, value, bRelative, CONFIG_ACCESS_MODE.FROM_SCRIPT)
    end
end

function __PURE__reset_config(key, value)
    local a, b = string.find(key, "pp")
    if a==1 then
        a, b = string.find(key, "ppTonemapUtils")
        if a==1 then
            return __PURE__set_root_config(key, value)
            --_l_ConfigRoot:writeFileAfterUpdate(_l_rootconfig_file)
        else
            return __PURE__reset_PP_config(key)
        end
    else
        return _l_Config:setEntry(key, value, false, CONFIG_ACCESS_MODE.RESET_TO_DEFAULTS)
    end
end

function __PURE__clear_config_backup()
    _l_Config:clearBackup() 
end
function __PURE__make_config_backup()
    _l_Config:completeBackup() 
end
function __PURE__Config_app_reset()
    _l_Config.connect:addCommand("wfxreset", "")
end


function check_PPFilter_related_config()
    if _l_ppfilter_related_config_file~=nil then
        if file_exists(_l_ppfilter_related_config_file) then
            _l_Config.connect:addCommand("ui", "ppfilter_config_exists")
        else
            _l_Config.connect:addCommand("ui", "ppfilter_config_does_not_exists")
        end
    end
end







-- quality settings

local quality_settings = {

    {
        parameter = "shaders.groundfog.active",
        value = {false, true, true, true},
    },
    {
        parameter = "shaders.groundfog.Quality",
        value = {1, 2, 3, 4},
    },
    {
        parameter = "shaders.groundfog.Render_distance",
        value = {1.0, 1.5, 2.0, 3.0},
    },
    {
        parameter = "shaders.groundfog.Volumetric_headlights",
        value = {false, false, true, true},
    },
    {
        parameter = "shaders.groundfog.Car_turbulences",
        value = {false, false, false, true},
    },
}

local quality_strings = {
    "Low quality settings loaded.",
    "Medium quality settings loaded.",
    "High quality settings loaded.",
    "Very high quality settings loaded.",
}

local function set_quality(n)

    for i,v in ipairs(quality_settings) do
        _l_Config:setEntry(v.parameter, v.value[n], false, CONFIG_ACCESS_MODE.FROM_INTERFACE)
    end

    _l_Config.connect:addCommand("system", quality_strings[n])
    _l_Config:resetPure()
end

local function determine_set_quality_settings()

    local quali = 0
    local tmp_quali = 0
    local tmp = 0
    local diff = 1e8
    local tmp_diff = 0
    
    for i,v in ipairs(quality_settings) do
        tmp =  _l_Config:getEntry(v.parameter)
        if tmp~=nil then

            tmp_quali = 0
            tmp_diff = 0

            if type(v.value[1]) == "boolean" then
                if tmp then
                    for ii=1,4 do
                        if v.value[ii] then
                            tmp_quali = math.max(ii, quali)
                            break
                        end
                    end
                else
                    tmp_quali = quali
                end
            else
                for ii=1,4 do
                    if tmp >= v.value[ii] then
                        tmp_quali = ii
                    end
                end
            end

            quali = (quali + tmp_quali) * 0.5
        end
    end

    __PURE__STATE:setValue("settings.quality", math.round(quali))
end







function handleCommandFromPureConfigApp(cmd, value)

    if cmd == "resetPure" then
        _l_Config:resetPure(true) -- clear the parameter backup withg this reset
    elseif cmd == "resetToDefaults" then
        _l_Config:resetToDefaults()
        _l_Config.connect:addCommand("system", "all settings are default")
    elseif cmd == "Load" then
        if _l_ppfilter_related_config_file__loaded~=nil and _l_ppfilter_related_config_file__loaded~="" then
            _l_Config.connect:addCommand("system", "PPfilter related Config file loaded")
            -- do nothing, the config in the script path will be reloaded anyway
        else
            _l_Config_Parser:readFile(_l_config_file)
            _l_Config:clearBackup()
            _l_Config:loadSettings(_l_Config_Parser)
            _l_Config.connect:addCommand("system", "Config file loaded")
        end
        _l_Config:resetPure()
    elseif cmd == "Save" then
        if _l_ppfilter_related_config_file__loaded~=nil and _l_ppfilter_related_config_file__loaded~="" then
            _l_Config:writeFile(_l_ppfilter_related_config_file__loaded)
            _l_Config.connect:addCommand("system", "PPfilter related Config file saved")
        else
            _l_Config:writeFile(_l_config_file)
            _l_Config.connect:addCommand("system", "Config file saved")
        end
        _l_Config:clearBackup()
    elseif cmd == "SaveUserConfig" then
        _l_Config:writeFile(_l_config_file)
        _l_Config.connect:addCommand("system", "Config file saved")
        _l_Config:clearBackup()
    elseif cmd =="saveTrackSpecific" then
        _l_Config:writeFile(_l_config_track_file)
        _l_Config:clearBackup()
        _l_Config.connect:addCommand("system", "Track specific config saved")
        _l_Config:resetPure()
    elseif cmd =="loadTrackSpecific" then
        if file_exists(_l_config_track_file) then
            _l_Config:clearBackup()
            _l_Config_Parser:readFile(_l_config_track_file)
            _l_Config:loadSettings(_l_Config_Parser)
            _l_Config.connect:addCommand("system", "Track specific config loaded")
            _l_Config:completeBackup()
            _l_Config:resetPure()
        else
            _l_Config.connect:addCommand("system_warning", "No track specific config available")
        end
    elseif cmd =="deleteTrackSpecific" then
        if file_exists(_l_config_track_file) then
            _l_Config:deleteFile(_l_config_track_file)
            _l_Config.connect:addCommand("system", "Track specific config deleted")
            _l_Config:clearBackup()
            _l_Config:resetPure()
        else
            _l_Config.connect:addCommand("system_warning", "No track specific config available")
        end
    elseif cmd =="SCRIPTexportPPFILTERconfig" then
        if _l_ppfilter_related_config_file~=nil then
            _l_Config:writeFile(_l_ppfilter_related_config_file)
            _l_Config.connect:addCommand("system", "PPfilter related Config file exported")
            _l_Config:clearBackup()
            _l_Config:resetPure()
        end
    elseif cmd =="SCRIPTdeletePPFILTERconfig" then
        if _l_ppfilter_related_config_file__loaded ~= nil then
            if file_exists(_l_ppfilter_related_config_file__loaded) then
                _l_Config:deleteFile(_l_ppfilter_related_config_file__loaded)
                _l_Config.connect:addCommand("system", "PPfilter related Config file removed")
                _l_Config:clearBackup()
                _l_Config:resetPure()
            end
        end
    elseif cmd == "Export" then
        if value and value~="" then
            _l_Config:writeFile(value)
            _l_Config.connect:addCommand("system", "Config file exported")
        end
    elseif cmd == "Import" then
        if value and value~="" then
            _l_Config:clearBackup()
            _l_Config_Parser:readFile(value)
            _l_Config:loadSettings(_l_Config_Parser)
            _l_Config.connect:addCommand("system", "Config file imported")
            _l_Config:completeBackup()
            _l_Config:resetPure()
        end
    elseif cmd == "RootSave" then
        __PURE__save_root_config()
        _l_Config.connect:addCommand("system", "Root Config saved")
    elseif cmd == "qualityLOW" then
        set_quality(1)
    elseif cmd == "qualityMEDIUM" then
        set_quality(2)
    elseif cmd == "qualityHIGH" then
        set_quality(3)
    elseif cmd == "qualityVERYHIGH" then
        set_quality(4)
    elseif cmd == "TabSelect" then
        _l_PureConfigSelectedTab = value
        if _l_PureConfigSelectedTab == "PP" then
            check_PPFilter_related_config()
            -- take the chance and check script settings file too, if pp tab is selected
            check_script_settings()
        elseif _l_PureConfigSelectedTab == "Main" then
            if not __ECO__ then
                determine_set_quality_settings()
            end
        end
    end
end


local _l_mode_state_set = false
function __PURE__update_config(dt)

    if not _l_config_init then

        if _l_Config.initialized then

            -- if config is seperated, change the config file name
            if __PURE__get_root_config("config.video_mode_separation") == true then
                if __AC_SIM then
                    if __AC_SIM.isVRMode and (not __AC_SIM.isPostProcessingActive) then
                        _l_config_file_add = "_VR_ppOff"
                        _l_config_file_mode = "VR + PP off"
                    elseif __AC_SIM.isVRMode then
                        _l_config_file_add = "_VR"
                        _l_config_file_mode = "VR"
                    elseif (not __AC_SIM.isPostProcessingActive) then
                        _l_config_file_add = "_ppOff"
                        _l_config_file_mode = "PP Off"
                    end
                end
            end


            -- ppfilter bound config files
            local _l_ppfilter_config = false

            local ppfilter = nil
            if ac.getPpFilter~=nil and ac.getPpFilter()=="" then
                local _l_AC_VIDEO = ac.INIConfig.videoConfig()
                ppfilter = _l_AC_VIDEO:get("POST_PROCESS","FILTER", "")
            else
                ppfilter = ac.getPpFilter()
            end
            

            if ppfilter~=nil and ppfilter~="" and ac.isPpActive() then
                -- filter is selected in video ini
                local sys_cfg_ppfilter_path = ac.getFolder(ac.FolderID.Root).."\\system\\cfg\\ppfilters\\purelcs_scripts\\"
                local tmp_ppfilter_config = ppfilter.."_PPconfig"

                if __PURE__get_root_config("config.video_mode_separation") == true then
                    if file_exists(sys_cfg_ppfilter_path..tmp_ppfilter_config.._l_config_file_add..".ini") then
                        _l_config_file = sys_cfg_ppfilter_path..tmp_ppfilter_config.._l_config_file_add..".ini"
                        _l_ppfilter_related_config_file__loaded = _l_config_file
                    else
                        -- if a special video mode config does not exist, try to use the normal config
                        if file_exists(sys_cfg_ppfilter_path..tmp_ppfilter_config..".ini") then
                            _l_config_file = sys_cfg_ppfilter_path..tmp_ppfilter_config..".ini"
                            _l_ppfilter_related_config_file__loaded = _l_config_file
                        end
                    end
                    -- store the right file name for later export function
                    _l_ppfilter_related_config_file = sys_cfg_ppfilter_path..tmp_ppfilter_config.._l_config_file_add..".ini"
                else
                    if file_exists(sys_cfg_ppfilter_path..tmp_ppfilter_config..".ini") then
                        _l_config_file = sys_cfg_ppfilter_path..tmp_ppfilter_config..".ini"
                        _l_ppfilter_related_config_file__loaded = _l_config_file
                    end
                    -- store the right file name for later export function
                    _l_ppfilter_related_config_file = sys_cfg_ppfilter_path..tmp_ppfilter_config..".ini"
                end

                check_PPFilter_related_config()
            end


            -- if config is seperated, change the config file name
            if _l_ppfilter_related_config_file__loaded==nil then
                if __PURE__get_root_config("config.video_mode_separation") == true then
                    if __AC_SIM then
                        _l_config_file = _l_config_path.."\\pure_config".._l_config_file_add..".ini"
                        if __PURE__get_root_config("config.track_specific_video_separation") == true then
                            _l_config_track_file = _l_config_path.."\\pure_config_".._l_track.._l_config_file_add..".ini"
                            _l_config_track_file_short = "pure_config_".._l_track.._l_config_file_add..".ini"
                        end
                    end
                else
                end
            end

            -- load the actual config file
            _l_Config:setCommandHandler(handleCommandFromPureConfigApp)

            if _l_ppfilter_related_config_file__loaded==nil then
                if not file_exists(_l_config_file) then
                    _l_Config:writeFile(_l_config_file)
                end
            end
            
            local tmp = _l_config_file
            if __PURE__get_root_config("config.track_specific_loading") == true then
                if file_exists(_l_config_track_file) then
                    tmp = _l_config_track_file
                    _l_config_track_file_used = true
                end
            end

            _l_Config_Parser:readFile(tmp)
            if _l_Config:loadSettings(_l_Config_Parser) then
                -- if loaded ini differs, update ini with loaded values
                _l_Config:writeFile(tmp)
                _l_Config.connect:addCommand("system", "config file updated")
            else
                

            end
            local age = _l_Config_Parser:getAge()

            
            
            -- check for forced update settings
            local forced_settings_file = __pure__path.."\\forced_settings.ini"
            if file_exists(forced_settings_file) then
                -- check the date, it will be written if no date is inside the file
                _l_Config_Parser:validateDate(forced_settings_file)
                _l_Config_Parser:readFile(forced_settings_file)
                age = _l_Config_Parser:getAge() - age
                if age > 1 then
                    -- if saved config is older then the forced settings file
                    _l_Config:loadSettings(_l_Config_Parser)
                    _l_Config:writeFile(tmp)
                    _l_Config.connect:addCommand("system", "config file updated")
                end
            end

            _l_config_init = true
            __PURE__Config_app_reset()
        end
    else
        _l_Config:update(dt)

        if not _l_mode_state_set then
            -- if Pure states are ready, set the current config mode to tell the apps
            if __PURE__STATE:isRegistered() then
                __PURE__STATE:setString("config.usedfile", _l_config_file_mode)
                __PURE__STATE:setString("config.ppfilterrelatedfile", _l_ppfilter_related_config_file__loaded or "")
                if _l_config_track_file_used then
                    __PURE__STATE:setString("config.usedtrackfile", _l_config_track_file_short)
                else
                    __PURE__STATE:setString("config.usedtrackfile", "")
                end
                _l_mode_state_set = true
            end
        end


        if _l_PureConfigSelectedTab == "Info" then
            -- some controls for the Pure Config app "Info" tab.
            local tmp_value = 1 + 2*(math.sin(os.clock()*0.01) + 1)
            _l_Config:setEntry("info.test_slider2", tmp_value, true, CONFIG_ACCESS_MODE.FROM_SCRIPT)

            tmp_value = 2 - 3*math.sin(os.clock()*0.01)
            _l_Config:setEntry("info.test_slider3", tmp_value, false, CONFIG_ACCESS_MODE.FROM_SCRIPT)
        end
    end

    return _l_config_init
end


